CREATE TABLE T_ANTONYM (
       ID                   INTEGER NOT NULL,
       ANTONYM_CHAIN_ID     INTEGER NOT NULL,
       WORD_ID              INTEGER NOT NULL,
       ORDER_NO             INTEGER NOT NULL,
       COMMENT              VARCHAR(50) NOT NULL
);

CREATE UNIQUE INDEX XPKT_ANTONYM ON T_ANTONYM
(
       ID
);


ALTER TABLE T_ANTONYM
       ADD PRIMARY KEY (ID);


CREATE TABLE T_ANTONYM_CHAIN (
       ID                   INTEGER NOT NULL,
       COMMENT              VARCHAR(100)
);

CREATE UNIQUE INDEX XPKT_ANTONYM_CHAIN ON T_ANTONYM_CHAIN
(
       ID
);


ALTER TABLE T_ANTONYM_CHAIN
       ADD PRIMARY KEY (ID);


CREATE TABLE T_HOMONYM (
       ID                   INTEGER NOT NULL,
       FIRST_WORD_ID        INTEGER NOT NULL,
       SECOND_WORD_ID       INTEGER NOT NULL
);

CREATE UNIQUE INDEX XPKT_HOMONYM ON T_HOMONYM
(
       ID
);


ALTER TABLE T_HOMONYM
       ADD PRIMARY KEY (ID);


CREATE TABLE T_HYPERONYM (
       ID                   INTEGER NOT NULL,
       WORD_ID              INTEGER,
       HYPONYM_CHAIN_ID     INTEGER NOT NULL,
       MEANING_CONTEXT      VARCHAR(150),
       WORD                 VARCHAR(100)
);

CREATE UNIQUE INDEX XPKT_HYPERONYM ON T_HYPERONYM
(
       ID
);


ALTER TABLE T_HYPERONYM
       ADD PRIMARY KEY (ID);


CREATE TABLE T_HYPONYM (
       ID                   INTEGER NOT NULL,
       HYPONYM_CHAIN_ID     INTEGER NOT NULL,
       WORD_ID              INTEGER NOT NULL
);

CREATE UNIQUE INDEX XPKT_HYPONYM ON T_HYPONYM
(
       ID
);


ALTER TABLE T_HYPONYM
       ADD PRIMARY KEY (ID);


CREATE TABLE T_HYPONYM_CHAIN (
       ID                   INTEGER NOT NULL,
       IN_DICTIONARY        SMALLINT NOT NULL
);

CREATE UNIQUE INDEX XPKT_HYPONYM_CHAIN ON T_HYPONYM_CHAIN
(
       ID
);


ALTER TABLE T_HYPONYM_CHAIN
       ADD PRIMARY KEY (ID);


CREATE TABLE T_LANG (
       CODE                 VARCHAR(2) NOT NULL,
       DESCRIPTION          VARCHAR(30)
);

CREATE UNIQUE INDEX XPKT_LANG ON T_LANG
(
       CODE
);


ALTER TABLE T_LANG
       ADD PRIMARY KEY (CODE);


CREATE TABLE T_MEANING (
       ID                   INTEGER NOT NULL,
       LANG_CODE            VARCHAR(2) NOT NULL,
       MEANING              TEXT NOT NULL  
       /* Note: The type "TEXT" denotes character sequence of variable unlimited length */
);

CREATE UNIQUE INDEX XPKT_MEANING ON T_MEANING
(
       ID
);


ALTER TABLE T_MEANING
       ADD PRIMARY KEY (ID);


CREATE TABLE T_SYNONYM (
       ID                   INTEGER NOT NULL,
       FIRST_WORD_ID        INTEGER NOT NULL,
       SECOND_WORD_ID       INTEGER NOT NULL,
       IS_ABSOLUTE          SMALLINT NOT NULL
);

CREATE UNIQUE INDEX XPKT_SYNONYM ON T_SYNONYM
(
       ID
);


ALTER TABLE T_SYNONYM
       ADD PRIMARY KEY (ID);


CREATE TABLE T_WORD (
       ID                   INTEGER NOT NULL,
       LANG_CODE            VARCHAR(2) NOT NULL,
       WORD                 VARCHAR(150) NOT NULL,
       MORE_INFO            VARCHAR(250)
);

CREATE UNIQUE INDEX XPKT_WORD ON T_WORD
(
       ID
);


ALTER TABLE T_WORD
       ADD PRIMARY KEY (ID);


CREATE TABLE TM_WORD_MEANING (
       ID                   INTEGER NOT NULL,
       MEANING_ID           INTEGER NOT NULL,
       WORD_ID              INTEGER NOT NULL
);

CREATE UNIQUE INDEX XPKTM_WORD_MEANING ON TM_WORD_MEANING
(
       ID
);

CREATE UNIQUE INDEX UK_WORD_MEANING ON TM_WORD_MEANING
(
       WORD_ID,
       MEANING_ID
);


ALTER TABLE TM_WORD_MEANING
       ADD PRIMARY KEY (ID);


ALTER TABLE T_ANTONYM
       ADD FOREIGN KEY (ANTONYM_CHAIN_ID)
                             REFERENCES T_ANTONYM_CHAIN;


ALTER TABLE T_ANTONYM
       ADD FOREIGN KEY (WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_HOMONYM
       ADD FOREIGN KEY (SECOND_WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_HOMONYM
       ADD FOREIGN KEY (FIRST_WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_HYPERONYM
       ADD FOREIGN KEY (HYPONYM_CHAIN_ID)
                             REFERENCES T_HYPONYM_CHAIN;


ALTER TABLE T_HYPERONYM
       ADD FOREIGN KEY (WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_HYPONYM
       ADD FOREIGN KEY (HYPONYM_CHAIN_ID)
                             REFERENCES T_HYPONYM_CHAIN;


ALTER TABLE T_HYPONYM
       ADD FOREIGN KEY (WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_MEANING
       ADD FOREIGN KEY (LANG_CODE)
                             REFERENCES T_LANG;


ALTER TABLE T_SYNONYM
       ADD FOREIGN KEY (SECOND_WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_SYNONYM
       ADD FOREIGN KEY (FIRST_WORD_ID)
                             REFERENCES T_WORD;


ALTER TABLE T_WORD
       ADD FOREIGN KEY (LANG_CODE)
                             REFERENCES T_LANG;


ALTER TABLE TM_WORD_MEANING
       ADD FOREIGN KEY (MEANING_ID)
                             REFERENCES T_MEANING;


ALTER TABLE TM_WORD_MEANING
       ADD FOREIGN KEY (WORD_ID)
                             REFERENCES T_WORD;
